import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Button from '@crm/components/dist/lego2/Button';
import { useContextState } from '../../../State';

export const SelectedCategoriesButton: FC = observer(() => {
  const state = useContextState();
  const { tree, tabs } = state;

  const isDisabled = tree.finiteSelected.length === 0;
  const view = tabs.current === 'selected' ? 'action' : 'pseudo';
  const handleClick = () => {
    if (tabs.current === 'selected') {
      tabs.go('tree');
    } else {
      tabs.go('selected');
    }
  };

  return (
    <Button view={view} disabled={isDisabled} onClick={handleClick}>
      Выбранные категории ({tree.finiteSelected.length})
    </Button>
  );
});
