import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Button from '@crm/components/dist/lego2/Button';
import { SearchInput } from './SearchInput';
import { SelectedCategoriesButton } from './SelectedCategoriesButton';
import { SaveButton } from './SaveButton';
import { useContextState } from '../../State';
import css from './TopBar.module.css';

export const TopBar: FC = observer(() => {
  const state = useContextState();
  const { close, emit } = state;

  const handleCancel = () => {
    close();
    emit('cancel');
  };

  return (
    <aside className={css.TopBar}>
      <SearchInput className={css.TopBar__searchInput} />
      <SelectedCategoriesButton />

      <div className={css.TopBar__buttons}>
        <Button className={css.TopBar__button} view="pseudo" onClick={state.fullness.off}>
          Свернуть
        </Button>
        <SaveButton className={css.TopBar__button} />
        <Button className={css.TopBar__button} view="pseudo" onClick={handleCancel}>
          Отменить
        </Button>
      </div>
    </aside>
  );
});
