import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Category } from '../../../Category';
import { CategoryListProps } from './CategoryList.types';

export const CategoryList: FC<CategoryListProps> = observer((props) => {
  const { categories, onClick, onChange, depth } = props;
  return (
    <>
      {categories.map((category) => (
        <Category
          key={category.id}
          category={category}
          content={category.name}
          canSelect={depth !== 0}
          onChange={onChange}
          onClick={onClick}
          role="treeitem"
          hasExpandingArrow={!category.isLeaf}
        />
      ))}
    </>
  );
});
