import React, { FC, useEffect, useRef } from 'react';
import { observer } from 'mobx-react-lite';
import css from './Column.module.css';
import { ColumnProps } from './Column.types';
import { columnTestId } from './Column.constants';
import { CategoryList } from './CategoryList/CategoryList';

export const Column: FC<ColumnProps> = observer((props) => {
  const { categories = [], depth } = props;
  const nodeRef = useRef<HTMLDivElement>(null);

  const scrollToIndex = (index: number) => {
    if (!nodeRef.current) {
      return;
    }

    const nodeToScroll = nodeRef.current.children[index];

    if (nodeToScroll) {
      nodeToScroll.scrollIntoView({
        block: 'nearest',
      });
    }
  };

  const handleChange = (id: number, value: boolean) => {
    if (props.onChange) {
      props.onChange(id, value);
    }
  };

  const handleClick = (id: number) => {
    const index = categories.findIndex((category) => category.id === id);
    scrollToIndex(index);
    if (props.onClick) {
      props.onClick(id, props.depth);
    }
  };

  useEffect(() => {
    const highlightedIndex = categories.findIndex((category) => category.highlighting.state);
    scrollToIndex(highlightedIndex);
  }, [categories]);

  return (
    <div className={css.Column} data-testid={columnTestId} ref={nodeRef}>
      <CategoryList
        categories={categories}
        onClick={handleClick}
        onChange={handleChange}
        depth={depth}
      />
    </div>
  );
});
