import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Column } from '../../Column';
import { ExpandedColumnProps } from './ExpandedColumn.types';

export const ExpandedColumn: FC<ExpandedColumnProps> = observer((props) => {
  const { tree, id, depth, onClick, onChange } = props;
  const { getById } = tree;
  const categories = ((getById(id) || {}).items || []).map((childId) => getById(childId)!);

  return <Column depth={depth} categories={categories} onClick={onClick} onChange={onChange} />;
});
