import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { ExpandedColumnsProps } from './ExpandedColumns.types';
import { ExpandedColumn } from './ExpandedColumn';

export const ExpandedColumns: FC<ExpandedColumnsProps> = observer((props) => {
  const { tree, onChange, onClick } = props;
  const { expanded } = tree;

  return (
    <>
      {expanded.map((id, index) => {
        return (
          <ExpandedColumn
            key={id}
            id={id}
            tree={tree}
            depth={index + 1}
            onClick={onClick}
            onChange={onChange}
          />
        );
      })}
    </>
  );
});
