import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Column } from '../Column';
import { FirstColumnProps } from './FirstColumn.types';

export const FirstColumn: FC<FirstColumnProps> = observer((props) => {
  const { onClick, onChange, tree } = props;
  const { root, getById } = tree;
  return (
    <Column
      depth={0}
      categories={root.map((id) => getById(id)!)}
      onClick={onClick}
      onChange={onChange}
    />
  );
});
