import React, { FC, useEffect, useRef } from 'react';
import { observer } from 'mobx-react-lite';
import { HorizontalScrollingProps } from './HorizontalScrolling.types';

export const HorizontalScrolling: FC<HorizontalScrollingProps> = observer((props) => {
  const { getSize, children, ...rest } = props;
  const nodeRef = useRef<HTMLDivElement>(null);
  const size = getSize();

  useEffect(() => {
    if (!nodeRef.current) {
      return;
    }

    nodeRef.current.scrollLeft = size;
  }, [size]);

  return (
    <div {...rest} ref={nodeRef}>
      {children}
    </div>
  );
});
