import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Spin from '@crm/components/dist/lego2/Spin';
import { FirstColumn } from './FirstColumn';
import { ExpandedColumns } from './ExpandedColumns';
import { spinnerTestId, notFoundTextTestId, COLUMN_WIDTH } from './Tree.constants';
import { useContextState } from '../../State';
import { TreeProps } from './Tree.types';
import css from './Tree.module.css';
import { HorizontalScrolling } from './HorizontalScrolling/HorizontalScrolling';

export const Tree: FC<TreeProps> = observer((props) => {
  const state = useContextState();
  const { onChange } = props;
  const { root, selectCategory, loading, changeLeafValue } = state.tree;

  const handleChange = (id: number, value: boolean) => {
    changeLeafValue(id, value);
    if (onChange) {
      onChange(id, value);
    }
  };

  return (
    <HorizontalScrolling
      getSize={() => state.tree.expanded.length * COLUMN_WIDTH}
      className={css.Tree}
      role="treegrid"
    >
      {loading.state && (
        <Spin progress view="default" position="center" size="m" data-testid={spinnerTestId} />
      )}
      {!loading.state && Boolean(root.length) && (
        <>
          <FirstColumn tree={state.tree} onClick={selectCategory} onChange={handleChange} />
          <ExpandedColumns tree={state.tree} onClick={selectCategory} onChange={handleChange} />
        </>
      )}
      {!loading.state && !root.length && (
        <div data-testid={notFoundTextTestId} className={css.Tree__notFoundText}>
          Категории отсутствуют
        </div>
      )}
    </HorizontalScrolling>
  );
});
