import React, { ComponentType, FC } from 'react';
import { observer } from 'mobx-react-lite';
import { TreeProps } from './Tree.types';
import { useContextState } from '../../State';
import { EmittingPayload } from '../../types';

export const withEmitting = (Tree: ComponentType<TreeProps>): FC =>
  observer(() => {
    const state = useContextState();
    const { tree, emit } = state;
    const { getById } = tree;

    const handleChange = (id: number, value: boolean) => {
      const parentCategory = getById(getById(id)!.parentId!)!;
      const siblingIds = parentCategory.items || [];
      const data: EmittingPayload = {
        block: 'tree',
        categoryId: id,
        resultsCount: siblingIds.length,
        order: siblingIds.findIndex((categoryId) => categoryId === id) + 1,
      };

      if (value) {
        emit('categoryTurnOn', data);
      } else {
        emit('categoryTurnOff', data);
      }
    };

    return <Tree onChange={handleChange} />;
  });
