import React, { FC } from 'react';
import cx from 'classnames';
import { observer } from 'mobx-react-lite';
import Button from '@crm/components/dist/lego2/Button';
import css from './Widget.module.css';
import { WidgetProps } from './Widget.types';
import { useContextState } from '../../State';

export const Widget: FC<WidgetProps> = observer((props) => {
  const className = cx(css.Widget, props.className);
  const state = useContextState();
  const { open, emit } = state;

  const handleClick = () => {
    open({
      previewComponent: props.Preview,
      search: props.onSearch,
      save: props.onSave,
      loadTip: props.onTipLoad,
      load: props.onLoad,
      targetMeta: props.targetMeta,
      changeStrategy: props.changeStrategy,
      commentSubmit: props.onTipComment,
      loadAlerts: props.onAlertsLoad,
      emitter: props.emitter,
    });
    emit('open');
  };

  if (props.mini) {
    return (
      <Button view="pseudo" onClick={handleClick}>
        Разметить
      </Button>
    );
  }

  return (
    <div className={className}>
      <div className={css.Widget__top}>
        <span className={css.Widget__title}>Категории</span>
        {props.middle}
        <Button view="clear" onClick={handleClick} className={css.Widget__button}>
          Разметить
        </Button>
      </div>
      {props.under}
    </div>
  );
});
