import { ComponentType } from 'react';
import {
  CategoriesObject,
  TargetMeta,
  ChangeStrategyType,
  TextHighlightingById,
  CommentFormExternalHandler,
  AlertLoadHandler,
  StoreEmitter,
} from '../../types';

export interface WidgetProps {
  className?: string;
  Preview?: ComponentType;
  emitter?: StoreEmitter;
  onLoad?: () => Promise<CategoriesObject>;
  onTipLoad?: (id: number) => Promise<string>;
  onSearch?: (
    text: string,
  ) => Promise<{
    resultIds: number[];
    highlightRangesById: TextHighlightingById;
  }>;
  onSave?: (value: { id: number }[]) => void;
  onTipComment?: CommentFormExternalHandler;
  onAlertsLoad?: AlertLoadHandler;
  targetMeta: TargetMeta;
  middle?: React.ReactNode;
  under?: React.ReactNode;
  mini?: boolean;
  changeStrategy?: ChangeStrategyType;
}
