import { schema } from 'normalizr';

export const categorySchema = new schema.Entity(
  'category',
  {},
  {
    processStrategy: (entity, parent) => {
      if (entity && parent) {
        return {
          ...entity,
          parentId: parent.id,
        };
      }

      return entity;
    },
  },
);

categorySchema.define({
  items: [categorySchema],
});
