import { normalize } from 'normalizr';
import { ById, DenormalizedCategory, GetById, CategoryDTO, Category as ICategory } from './types';
import { categorySchema } from './schemas';
import { Category } from './State/defaultStores/Category';

export const getPathFromHighestParent = (
  getById: GetById<CategoryDTO | ICategory>,
  id: number,
): number[] => {
  const pathToHighestParent: number[] = [id];

  let category = getById(id);
  if (!category) {
    return [];
  }

  if (category.parentId == null) {
    return pathToHighestParent;
  }

  while (category && category.parentId != null) {
    pathToHighestParent.push(category.parentId);
    category = getById(category.parentId);
  }

  return pathToHighestParent.reverse();
};

export const filterRootIds = (
  getById: GetById<ICategory | CategoryDTO>,
  ids: number[],
): number[] => {
  return ids.filter((id) => getById(id) && getById(id)!.parentId != null);
};

export const createCategory = (
  id: number,
  children: DenormalizedCategory[] = [],
): DenormalizedCategory => {
  return {
    id,
    name: id.toString(),
    isLeaf: !children.length,
    items: children,
  };
};

export const createById = (rootCategories: DenormalizedCategory[]): ById => {
  const normalizedData = normalize(rootCategories, [categorySchema]);
  const byId = normalizedData.entities.category || {};

  return Object.keys(byId).reduce(
    (acc, id) => ({
      ...acc,
      [id]: new Category(byId[id]),
    }),
    {},
  );
};
