import * as React from 'react';

interface Props {
  className?: string;
}

interface State {
  chatId: string | null;
}

class FakeChat extends React.Component<Props, State> {
  private chats = {
    chat1: {
      chatId: 'chatId1',
      orgId: 'orgId1',
    },
    chat2: {
      chatId: 'chatId2',
      orgId: 'orgId2',
    },
    chat3: {
      chatId: 'chatId3',
      orgId: 'orgId3',
    },
  };

  public state: State = {
    chatId: null,
  };

  private handleChatEnter = e => {
    const { chatId } = this.state;

    if (chatId) {
      window.postMessage(
        {
          type: 'chat-leave',
          payload: this.chats[chatId],
        },
        '*',
      );
    }

    const { chatId: newChatId } = e.target.dataset;

    window.postMessage(
      {
        type: 'chat-enter',
        payload: this.chats[newChatId],
      },
      '*',
    );

    this.setState({ chatId: newChatId });
  };

  private handleChatExit = () => {
    const { chatId } = this.state;
    if (chatId) {
      window.postMessage(
        {
          type: 'chat-leave',
          payload: this.chats[chatId],
        },
        '*',
      );

      this.setState({ chatId: null });
    }
  };

  public render() {
    const { chatId } = this.state;

    return (
      <div {...this.props}>
        {Object.keys(this.chats).map(key => (
          <button
            key={key}
            data-chat-id={key}
            disabled={chatId === key}
            onClick={this.handleChatEnter}
            type="button"
          >
            {key}
          </button>
        ))}
        <button type="button" onClick={this.handleChatExit}>
          выйти из чата
        </button>
      </div>
    );
  }
}

export default FakeChat;
