import React from 'react';
import { storiesOf } from '@storybook/react';
import ChatList from './ChatList';
import ChatListContainer from './ChatListContainer';
import { Direction } from './types.d.ts';

const messages = [
  {
    id: 1,
    text: 'text',
    date: '2012-01-03T15:01:41.0000000+04:00',
    direction: Direction.In,
  },
  {
    id: 2,
    text: 'text',
    date: '2012-01-03T15:01:41.0000000+04:00',
    direction: Direction.Out,
  },
  {
    id: 3,
    text:
      'textasdfsfsdfsjfsdjfklasjflkasjfsalfjsdlfjaslfasdjflasjfsaldfjsalfksjdlfasjflasjfasldfjaslfjasdlfasjdflasjfsldfjaslfjasdflsaj',
    date: '2012-01-03T15:01:41.0000000+04:00',
    direction: Direction.Out,
  },
];

storiesOf('ChatList', module).add('ChatList', () => (
  <ChatList style={{ maxWidth: 400 }} messages={messages} />
));

storiesOf('ChatList', module).add('ChatListContainer', () => <ChatListContainer id={1} />);
