import * as React from 'react';
import cx from 'classnames';
import css from './ChatList.scss';
import Message from './Message';
import { IMessage } from './types';

interface Props {
  className?: string;
  messages?: IMessage[];
  style?: any;
}

const ChatList = (props: Props) => {
  const { messages, className, style } = props;

  if (!(Array.isArray(messages) && messages.length)) {
    return null;
  }

  return (
    <div className={cx(css.b, className)} style={style}>
      {messages
        .slice()
        .reverse()
        .map(message => (
          <Message key={message.id} message={message} />
        ))}
    </div>
  );
};

export default ChatList;
