import * as React from 'react';
import Promise from 'bluebird';
import { get } from 'api/common';
import applyMixins from 'utils/applyMixins';
import Loadable from 'utils/Loadable';
import { IMessage } from './types.d';
import ChatList from './ChatList';

interface Props {
  id: number;
}

interface State {
  data?: {
    items?: IMessage[];
  };
  isLoad: boolean;
}

class ChatListContainer extends React.Component<Props, State> {
  public state: State = { isLoad: false };

  public componentDidMount(): void {
    this.load();
  }

  public componentDidUpdate(prevProps): void {
    if (this.props.id !== prevProps.id) {
      if (this.props.id) {
        this.load();
      } else {
        this.clearData();
      }
    }
  }

  public componentWillUnmount(): void {
    this.loadCancel();
  }

  public clearData() {
    this.setState({ data: undefined });
  }

  public loadRequest(): Promise<any> {
    const { id } = this.props;

    return get({
      url: '/view/chat',
      data: {
        chunkId: id,
      },
    }).then(data => {
      if (data && data.chatChunk) {
        this.setState({ isLoad: true, data: data.chatChunk });
      }
    });
  }

  public render() {
    const { data, isLoad } = this.state;

    if (!(isLoad && data)) {
      return null;
    }

    return <ChatList messages={data.items} />;
  }
}

interface ChatListContainer extends Loadable {}
applyMixins(ChatListContainer, [Loadable]);

export default ChatListContainer;
