import * as React from 'react';
import PreviewDate from 'components/PreviewValue/PreviewDate';
import cx from 'classnames';
import css from './Message.scss';
import { IMessage } from './types';

interface Props {
  message?: IMessage;
  showMonth?: boolean;
}

const Message = (props: Props) => {
  const { message, showMonth } = props;

  if (!message) {
    return null;
  }

  const { text, date, direction } = message;

  return (
    <div className={cx(css.b, css[`b_direction_${direction}`])}>
      {showMonth && (
        <div className={css.b__month}>
          <PreviewDate value={date} className={css.b__date} />
        </div>
      )}
      <div className={css.b__messageWrap}>
        <div className={css.b__message}>
          <span className={css.b__text}>{text}</span>
          {date && (
            <span className={css.b__info}>
              <PreviewDate value={date} className={css.b__date} time />
            </span>
          )}
        </div>
      </div>
    </div>
  );
};

export default Message;
