import * as React from 'react';
import { connect } from 'react-redux';
import redux from '../../redux';
import Layout, { Props as LayoutProps } from './Layout';
import { State } from '../../types';

interface Props extends LayoutProps {
  destroy: () => void;
}

class LayoutContainer extends React.Component<Props> {
  public componentWillUnmount() {
    this.props.destroy();
  }

  public render() {
    return <Layout {...this.props} />;
  }
}

export default connect(
  (state: { chat: State }) => ({
    accountId: redux.selectors.getAccountId(state),
    chat: redux.selectors.getChatData(state),
    categorization: redux.selectors.getCategorization(state),
    tip: redux.selectors.getTip(state),
  }),
  {
    onChangeAccount: redux.actions.connectAccount,
    onCategorizationChange: redux.actions.saveCategories,
    onChatEnter: redux.actions.chatEnter,
    onChatExit: redux.actions.chatExit,
    onTipClick: redux.actions.openTip,
    destroy: redux.actions.destroy,
  },
)(LayoutContainer);
