import * as React from 'react';
import { connect } from 'react-redux';
import { PanelScheme } from '@crm/components/dist/Panel';
import Panel from 'modules/panel';
import Iframe, { selectors as iframeSelectors } from 'components/Iframe';
import { PanelFiles, PanelEntity } from 'modules/clientHistory';
import css from './Panel.module.css';

interface OwnProps {
  accountId: number | string;
}

interface ConnectedState {
  tipUrl: string;
}

type Props = OwnProps & ConnectedState;

export const PANEL_NAME = 'chats/categorization';
export const TIPS_PANEL_ID = 'categorizationTips';

const ChatPanel: React.FC<Props> = (props) => {
  const { accountId, tipUrl } = props;
  const panels: PanelScheme[] = [];

  if (tipUrl) {
    panels.push({
      id: TIPS_PANEL_ID,
      title: 'Подсказки',
      content: (
        <div className={css.panelWrap}>
          <Iframe title="Подсказки" />
        </div>
      ),
    });
  }

  if (accountId != null) {
    panels.push({
      id: 'activity',
      title: 'История аккаунта',
      content: (
        <div className={css.panelWrap}>
          <PanelEntity
            key={accountId}
            param={{ clientId: accountId }}
            name="activity"
            loadOnMount
          />
        </div>
      ),
      keepMount: true,
      padding: false,
    });

    panels.push({
      id: 'files',
      title: 'Файлы аккаунта',
      content: (
        <div className={css.panelWrap}>
          <PanelFiles
            key={accountId}
            param={{ clientId: accountId }}
            name="files"
            loadOnMount
            showTitle={false}
          />
        </div>
      ),
      keepMount: true,
      padding: false,
    });
  }

  return panels.length ? (
    <Panel
      name={PANEL_NAME}
      defaultSize={{
        width: 550,
      }}
      minWidth={300}
      maxWidth={550}
      panels={panels}
    />
  ) : null;
};

export default connect(
  (state): ConnectedState => {
    const iframeSrc: string = iframeSelectors.getState(state);

    return {
      tipUrl: iframeSrc,
    };
  },
)(ChatPanel);
