import Promise from 'bluebird';

interface Account {
  id: number;
}

class FakeBackend {
  private storage = new Map();

  // по chatId получаем облегченную структуру account, accountId пойдет в карточку аккаунта,
  // которая знает как загружать/работать с данными
  public getAccountByChatId(chatId: string): Promise<{ account?: Account }> {
    return new Promise(resolve => {
      const account = this.storage.get(chatId);
      if (account) {
        resolve({ account });
      }

      resolve({});
    });
  }

  // связываем chatId с accountId, запрос пойдет одновременно с загрукой карточки
  public setAccountToChatId(chatId: string, account: Account): Promise<{}> {
    return new Promise(resolve => {
      this.storage.set(chatId, account);

      resolve({});
    });
  }
}

export default new FakeBackend();
