import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';
import { State } from '../types';
import * as actionTypes from './actionTypes';

const behaviors = {
  [actionTypes.CHANGE_ACCOUNT](state: State, action) {
    return {
      ...state,
      account: action.payload,
    };
  },
  [actionTypes.CHANGE_CATEGORIES](state: State, action) {
    return {
      ...state,
      categorization: action.payload,
    };
  },
  [actionTypes.CHANGE_TIP](state: State, action) {
    return {
      ...state,
      tip: action.payload,
    };
  },
  [actionTypes.CHAT_ENTER](state: State, action) {
    return {
      ...state,
      chat: action.payload,
    };
  },
  [actionTypes.CHAT_EXIT](state: State) {
    return {
      ...state,
      account: null,
      chat: null,
      categorization: null,
    };
  },
  [actionTypes.DESTROY]() {
    return {};
  },
};

export default reducerFactoryRaw(actionTypes, behaviors);
