import get from 'lodash/get';
import { Store, FloydChatData, Categorization, Tip } from 'modules/chat/types';
import { NAME } from '../constants';

type GetAccountId = (state: Store) => number | undefined;
export const getAccountId: GetAccountId = state => get(state, `${NAME}.account.id`);

type GetTip = (state: Store) => Tip;
export const getTip: GetTip = state => get(state, `${NAME}.tip`);

type GetChatId = (state: Store) => string | undefined;
export const getChatId: GetChatId = state => get(state, `${NAME}.chat.chatId`);

type GetChatData = (state: Store) => FloydChatData;
export const getChatData: GetChatData = state => get(state, `${NAME}.chat`);

type GetCategorization = (state: Store) => Categorization | undefined;
export const getCategorization: GetCategorization = state => get(state, `${NAME}.categorization`);
