export interface FloydChatData {
  chatId: string;
  orgId: string;
}

export interface CRMChatData {
  chatId: string;
  organizationId: string;
}

export interface Account {
  id: number;
}

export interface Tip {
  backgroundColor: string;
  body: string;
}

export interface Chat {
  chatId: string;
  orgId: string;
}

interface CategoryBase {
  id: number;
  fullName: string;
  name: string;
  top: boolean;
  available: boolean;
  forRequest: boolean;
  isLeaf: boolean;
}

export interface Reason extends CategoryBase {
  isReason: true;
  hasReasons: false;
}

export interface Category extends CategoryBase {
  isReason: false;
  hasReasons: true;
  items: Reason[];
}

interface CategorizationBase {
  selectedCategories: {
    [id: string]: {
      [reasonId: string]: number;
    };
  };
}

export interface BackendCategorization extends CategorizationBase {
  categories: Category[];
}

export interface Categorization extends CategorizationBase {
  categories: {
    [id: string]: Category;
  };
}

export type SavedCategories = {
  id: number;
}[];

export interface State {
  account: Account;
  chat: Chat;
  tip: Tip;
  categorization: Categorization;
}

export interface Store {
  chat: State;
}
