import { BackendCategorization, Categorization } from '../types';

export default (categorization?: BackendCategorization): Categorization => {
  if (!categorization) {
    return {
      categories: {},
      selectedCategories: {},
    };
  }

  const categories: Categorization['categories'] = categorization.categories.reduce(
    (acc, category) => {
      acc[category.id] = category;
      return acc;
    },
    {},
  );

  return {
    ...categorization,
    categories,
  };
};
