import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import CreateAccountForm from './CreateAccountForm';
import {
  CreateAccountConnectedDispatchFormProps,
  CreateAccountConnectedStateFormProps,
  CreateAccountConnectedOwnFormProps,
} from './CreateAccountForm.types';
import { CreateAccountData } from '../types';

const getIsOrganization = (values) => values.accountType === 'contractor';
const getIsLoginMetrika = (values) => values.accountType === 'metrika';

const validate = (values) => {
  const errors = {};
  const requiredFields = ['name', 'accountType'];

  if (getIsOrganization(values)) {
    requiredFields.push('orgId');
  }

  if (getIsLoginMetrika(values)) {
    requiredFields.push('loginMetrika');
  }

  requiredFields.forEach((field) => {
    if (
      !values[field] ||
      (Object.prototype.hasOwnProperty.call(values[field], 'length') && !values[field].length)
    ) {
      errors[field] = 'Обязательно для заполнения';
    }
  });

  return errors;
};

const CreateAccountReduxForm = reduxForm({ validate })(CreateAccountForm);

export default connect<
  CreateAccountConnectedStateFormProps,
  CreateAccountConnectedDispatchFormProps,
  CreateAccountConnectedOwnFormProps
>(
  (state, props) => {
    const formSelector = formValueSelector(props.name);

    const accountType = formSelector(state, 'accountType');

    return {
      isOrganization: getIsOrganization({ accountType }),
      isLoginMetrika: getIsLoginMetrika({ accountType }),
    };
  },
  (dispatch, props) => ({
    onSubmit: (data) => {
      const sendData = { ...data };
      if (!getIsOrganization(sendData)) {
        delete sendData.orgId;
      }

      return props.onSubmit(sendData as CreateAccountData);
    },
  }),
)(CreateAccountReduxForm);
