import React, { FC } from 'react';
import { Row } from 'forms/Base';
import Button from '@crm/components/dist/lego2/Button';
import withDictionary from 'lego/components/withDictionary';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Form from 'components/Form';
import * as keyset from '../clientCreateForm.i18n';
import { CreateAccountReduxFormProps } from './CreateAccountForm.types';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nLead = i18n('lead');
const i18nContractor = i18n('contractor');
const i18nMetrikaClient = i18n('metrikaClient');
const i18nMobileApp = i18n('mobileApp');
const i18nNewAccount = i18n('newAccount');
const i18nName = i18n('name');
const i18nAccountType = i18n('accountType');
const i18nOrganization = i18n('organization');
const i18nMetrikaLogin = i18n('metrikaLogin');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');

const type = [
  { value: 'lead', content: i18nLead },
  { value: 'contractor', content: i18nContractor },
  { value: 'metrika', content: i18nMetrikaClient },
  { value: 'mobileApp', content: i18nMobileApp },
];
const required = (value) => (value ? undefined : 'Required');

// TODO: refactoring types for withDictionary
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const Organization = withDictionary<any>({
  endpoint: '/view/dicts/organization',
})(Row);

const ClientCreateForm: FC<CreateAccountReduxFormProps> = (props) => {
  const { onCancel, valid, submitting, handleSubmit, isOrganization, isLoginMetrika } = props;

  return (
    <Form theme={Form.THEME.MODAL} onSubmit={handleSubmit}>
      <Form.Header>{i18nNewAccount}</Form.Header>
      <Form.Body>
        <Row component="TextInput" name="name" label={i18nName} autoFocus required />
        <Row
          name="accountType"
          label={i18nAccountType}
          hasEmptyValue={false}
          component="Select"
          options={type}
          required
        />
        {isOrganization && (
          <Organization
            name="orgId"
            label={i18nOrganization}
            hasEmptyValue={false}
            component="Select"
            validate={required}
            required
          />
        )}
        {isLoginMetrika && (
          <Row component="TextInput" name="loginMetrika" label={i18nMetrikaLogin} required />
        )}
      </Form.Body>
      <Form.Footer>
        <Button size="m" type="submit" disabled={!valid || submitting} view="action">
          {i18nSave}
        </Button>
        <Button size="m" onClick={onCancel}>
          {i18nCancel}
        </Button>
      </Form.Footer>
    </Form>
  );
};

export default ClientCreateForm;
