import { InjectedFormProps } from 'redux-form';
import { CreateAccountData, CreateAccountFormData } from '../types';

export interface CreateAccountFormProps {
  onCancel?: () => void;
  onSubmit: (values: CreateAccountData) => Promise<{}>;
  name: string;
  isOrganization: boolean;
  isLoginMetrika: boolean;
}

export type CreateAccountConnectedStateFormProps = Pick<
  CreateAccountFormProps,
  'isOrganization' | 'isLoginMetrika'
>;

export interface CreateAccountConnectedDispatchFormProps {
  onSubmit: (values: CreateAccountFormData) => Promise<{}>;
}

export type CreateAccountConnectedOwnFormProps = Omit<
  CreateAccountFormProps,
  keyof CreateAccountConnectedStateFormProps
>;

export type CreateAccountReduxFormProps = CreateAccountFormProps &
  InjectedFormProps<CreateAccountFormData, CreateAccountFormProps>;
