import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Loadable from 'utils/Loadable';
import applyMixins from 'utils/applyMixins';
import { saveClient } from '../withCreateApi/api';
import { CreateLeadButtonProps, CreateLeadButtonState } from './CreateLeadButton.types';

class CreateLeadButton extends React.Component<CreateLeadButtonProps, CreateLeadButtonState> {
  public constructor(props) {
    super(props);
    this.state = {
      isDisabled: false,
    };
  }

  public componentWillUnmount(): void {
    this.loadCancel();
  }

  private handleClick = (): void => {
    this.load();
  };

  public loadRequest() {
    const { onCreate } = this.props;

    this.setState({
      isDisabled: true,
    });

    return saveClient({ accountType: 'lead', name: 'hello' })
      .then((data) => {
        return onCreate({
          id: data.account.id,
          name: data.account.id,
        });
      })
      .finally(() => {
        this.setState({
          isDisabled: false,
        });
      });
  }

  public render(): JSX.Element {
    return (
      <Button
        {...this.props}
        onClick={this.handleClick}
        disabled={this.state.isDisabled || this.props.disabled}
      >
        Создать лид
      </Button>
    );
  }
}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
interface CreateLeadButton extends Loadable {}
applyMixins(CreateLeadButton, [Loadable]);

export default CreateLeadButton;
