import React from 'react';
import { formPropTypes } from 'redux-form';
import { Row } from 'forms/Base';
import Button from '@crm/components/dist/lego2/Button';
import withDictionary from 'lego/components/withDictionary';
import Form from 'components/Form';

const type = [
  { value: 'lead', content: 'Лид' },
  { value: 'contractor', content: 'Контрагент' },
  { value: 'metrika', content: 'Клиент Метрики' },
];

const Organization = withDictionary({
  endpoint: '/view/dicts/organization',
})(Row);

const ClientCreateForm = (props) => {
  const { onCancel, valid, submitting, handleSubmit, isOrganization, isLoginMetrika } = props;

  return (
    <Form theme={Form.THEME.MODAL} onSubmit={handleSubmit}>
      <Form.Header>Новый аккаунт</Form.Header>
      <Form.Body>
        <Row component="TextInput" name="name" label="Название" autoFocus required />
        <Row
          name="accountType"
          label="Тип аккаунта"
          hasEmptyValue={false}
          component="Select"
          options={type}
          required
        />
        {isOrganization && (
          <Organization
            name="orgId"
            label="Организация"
            hasEmptyValue={false}
            component="Select"
            required
          />
        )}
        {isLoginMetrika && (
          <Row component="TextInput" name="loginMetrika" label="Логин Метрики" required />
        )}
      </Form.Body>
      <Form.Footer>
        <Button size="m" type="submit" disabled={!valid || submitting} view="action">
          Сохранить
        </Button>
        <Button size="m" onClick={onCancel}>
          Отменить
        </Button>
      </Form.Footer>
    </Form>
  );
};

ClientCreateForm.propTypes = {
  ...formPropTypes,
};

export default ClientCreateForm;
