import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import { saveClient } from './api';
import Form from './Form';

const getIsOrganization = (values) => values.accountType === 'contractor';
const getIsLoginMetrika = (values) => values.accountType === 'metrika';

const validate = (values) => {
  const errors = {};
  const requiredFields = ['name', 'accountType'];

  if (getIsOrganization(values)) {
    requiredFields.push('orgId');
  }

  if (getIsLoginMetrika(values)) {
    requiredFields.push('loginMetrika');
  }

  requiredFields.forEach((field) => {
    if (
      !values[field] ||
      (Object.prototype.hasOwnProperty.call(values[field], 'length') && !values[field].length)
    ) {
      errors[field] = 'Обязательно для заполнения';
    }
  });

  return errors;
};

const ClientCreateForm = reduxForm({ validate })(Form);

export default connect(
  (state, props) => {
    const formSelector = formValueSelector(props.name);

    const accountType = formSelector(state, 'accountType');

    return {
      isOrganization: getIsOrganization({ accountType }),
      isLoginMetrika: getIsLoginMetrika({ accountType }),
    };
  },
  (dispatch, props) => ({
    onSubmit: (data) => {
      const sendData = { ...data };
      if (!getIsOrganization(sendData)) {
        delete sendData.orgId;
      }

      return saveClient(sendData).then((response) => {
        if (response.success === true) {
          if (typeof props.onSubmit === 'function') {
            props.onSubmit(response.account);
          }
        }

        return response;
      });
    },
  }),
)(ClientCreateForm);
