import React, { useCallback, ComponentType } from 'react';
import { saveClient } from './api';
import { WithCreateApiWrappedProps, WithCreateApiProps } from './withCreateApi.types';

export const withCreateApi = (WrappedComponent: ComponentType<WithCreateApiWrappedProps>) => {
  const WithCreateApi = (props: WithCreateApiProps) => {
    const { onSubmit: onSubmitProp, ...other } = props;

    const onSubmit = useCallback<WithCreateApiWrappedProps['onSubmit']>(
      (values) => {
        return saveClient(values).then((response) => {
          if (response.success === true) {
            if (typeof onSubmitProp === 'function') {
              onSubmitProp(response.account);
            }
          }

          return response;
        });
      },
      [onSubmitProp],
    );

    return <WrappedComponent {...other} onSubmit={onSubmit} />;
  };

  return WithCreateApi;
};
