import React from 'react';
import PropTypes from 'prop-types';
import LazilyLoad, { importLazy } from 'utils/LazilyLoad';

const ClientHistoryLazilyLoad = props => {
  const { accountId } = props;

  return (
    <LazilyLoad
      modules={{ clientHistoryModule: () => importLazy(import('modules/clientHistory')) }}
    >
      {({ clientHistoryModule }) => {
        const Component = clientHistoryModule.component;
        return (
          <Component
            key={`Client/${accountId}`}
            param={{ clientId: accountId }}
            initOnMount
            destroyOnUnmount
          />
        );
      }}
    </LazilyLoad>
  );
};

ClientHistoryLazilyLoad.propTypes = {
  accountId: PropTypes.number.isRequired,
};

export default ClientHistoryLazilyLoad;
