import get from 'lodash/get';
import * as api from 'api/common';
import { NAME } from './constants';
import filterDataToBackend from './utils/filterDataToBackend';
import getItemHash from './utils/getItemHash';
import * as selectors from './selectors';
export const TOGGLE_ITEM = `${NAME}TOGGLE_ITEM`;

export const RESET = `${NAME}RESET`;

export const SET_PANEL = `${NAME}SET_PANEL`;

export const ADD_YC_CALL = `${NAME}ADD_YC_CALL`;
export const SET_FETCHING_YC_CALL = `${NAME}SET_FETCHING_YC_CALL`;

export const toggleItem = (hash) => ({ type: TOGGLE_ITEM, data: hash });
export const reset = () => ({ type: RESET });
export const setPanel = (data) => ({ type: SET_PANEL, data });

const getLastParam = (state) => {
  const param = { ...get(state, `${NAME}.historyArgs`) };
  delete param.offset;
  return param;
};

// eslint-disable-next-line no-shadow
export const fetch = (args) => (dispatch, getState) => {
  let requestParam;
  const state = getState();

  const filterData = filterDataToBackend(selectors.filter(state), selectors.withFilters(state));

  if (args) {
    requestParam = { ...args, ...filterData };
  } else {
    requestParam = { ...getLastParam(state), ...filterData };
  }
  return api
    .post({ url: '/view/client/support/history', data: requestParam, global: false })
    .then((data) => {
      if (data && Array.isArray(data.items)) {
        return {
          ...data,
          items: data.items.map((item) => ({ ...item, hash: getItemHash(item) })),
        };
      }

      return data;
    });
};

export const loadFiles = (data) => () =>
  api.get({ url: '/view/client/support/files', data, global: false });

export const fetchYcCall = (issueId, id) => (dispatch) => {
  dispatch({ type: SET_FETCHING_YC_CALL, payload: { id, fetching: true } });
  return api
    .get({ url: `/actions/issue/${issueId}/call/${id}`, global: false })
    .then((data) => {
      dispatch({
        type: ADD_YC_CALL,
        payload: { call: data.data, categorization: data.categorization },
      });
    })
    .finally(() => {
      dispatch({ type: SET_FETCHING_YC_CALL, payload: { id, fetching: false } });
    });
};

export const fetchPersonalYcCall = (id) => (dispatch) => {
  dispatch({ type: SET_FETCHING_YC_CALL, payload: { id, fetching: true } });
  return api
    .get({ url: `activities/${id}/history` })
    .then((data) => {
      dispatch({
        type: ADD_YC_CALL,
        payload: { call: data.data, categorization: data.categorization },
      });
    })
    .finally(() => {
      dispatch({ type: SET_FETCHING_YC_CALL, payload: { id, fetching: false } });
    });
};

export const TOGGLE_WITH_FILTERS = `${NAME}TOGGLE_WITH_FILTERS`;
export const toggleWithFilters = () => ({ type: TOGGLE_WITH_FILTERS });

export const TOGGLE_SHOW_FILTERS = `${NAME}TOGGLE_SHOW_FILTERS`;
export const toggleShowFilters = () => ({ type: TOGGLE_SHOW_FILTERS });

export const SAVE_FILTER = `${NAME}SAVE_FILTER`;
export const saveFilter = (payload) => ({ type: SAVE_FILTER, payload });
