/*
eslint-disable
jsx-a11y/click-events-have-key-events,
jsx-a11y/no-static-element-interactions,
*/

import React from 'react';
import PropTypes from 'prop-types';
import ToolBar from './ItemToolBar';
import css from './styles.modules.scss';
import config from './config';

class ClientHistory extends React.Component {
  static propTypes = {
    initOnMount: PropTypes.bool,
    destroyOnUnmount: PropTypes.bool,
    reset: PropTypes.func.isRequired,
    setPanel: PropTypes.func.isRequired,
    panel: PropTypes.string,
  };

  static defaultProps = {
    initOnMount: false,
    destroyOnUnmount: false,
    panel: undefined,
  };

  componentDidMount() {
    /*
     * так как компонент инициализируется из localstorage (там запоминаем фильтры)
     * в state модуля попадает только ui, что приводит к ошибкам
     * */
    if (this.props.initOnMount) {
      this.props.reset();
    }
  }

  componentWillUnmount() {
    if (this.props.destroyOnUnmount) {
      this.props.reset();
    }
  }

  handleToolbarItemClick = e => {
    const { type } = e.currentTarget.dataset;
    const nextPanel = type || null;
    if (nextPanel === this.props.panel) {
      this.props.setPanel(null);
    } else {
      this.props.setPanel(nextPanel);
    }
  };

  renderPanel() {
    return config.list.map(key =>
      React.createElement(config.map[key].component, {
        key,
        hidden: this.props.panel !== key,
        param: this.props.param,
        name: key,
      }),
    );
  }

  render() {
    const { panel } = this.props;

    const wrapSpaceClass = panel ? `${css.wrapSpace} ${css.wrapAnimIn}` : css.wrapSpace;

    return (
      <div className={wrapSpaceClass}>
        <div className={css.wrap}>
          <div className={css.container}>
            <div className={css.toggle} onClick={this.handleToolbarItemClick}>
              <div className={css.toggle__icon}>
                <div className={css.toggle__circle} />
                <div className={css.toggle__circle} />
                <div className={css.toggle__circle} />
              </div>
            </div>
            {this.renderPanel()}
          </div>
          <ToolBar>
            {config.list.map(key => (
              <div
                key={key}
                title={config.map[key].title}
                onClick={this.handleToolbarItemClick}
                data-type={key}
                data-active={panel === key}
              >
                <i className="material-icons">{config.map[key].icon}</i>
              </div>
            ))}
          </ToolBar>
        </div>
      </div>
    );
  }
}

export default ClientHistory;
