import React from 'react';
import cx from 'classnames';
import css from './style.modules.scss';

const ToolBar = props => {
  const childrenWithProps = React.Children.map(props.children, child =>
    React.cloneElement(child, {
      className: cx(
        child.props.className,
        css.item,
        child.props['data-active'] ? css.active : null,
      ),
    }),
  );

  return <div className={cx(props.className, css.wrap)}>{childrenWithProps}</div>;
};

export default ToolBar;
