import React from 'react';
import cx from 'classnames';
import { actions, InfiniteListView, selectors } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import { injectIntl } from 'react-intl';
import { connect } from 'react-redux';
import createI18N from '@yandex-int/i18n';
import * as keyset from './ClientHistory.i18n';
import css from './styles.modules.scss';
import historyItemsConfig from '../HistoryItems';
import toolbarCss from './toolbar.modules.scss';
import Filters from '../Filters/Filters';
import * as a from '../../actions';
import * as c from '../../constants';
import PanelBase from './PanelBase';

const i18nNoHistory = createI18N(keyset)('noHistory');

class PanelEntity extends PanelBase {
  handleChange = filter => {
    this.props.saveFilter(filter);
  };

  handleClick = item => () => {
    this.props.toggleItem(item.hash);
  };

  renderTimeline = ({ items }) => {
    if (!items || !items.length) {
      return null;
    }

    let lastDisplayDate = null;
    const currentDate = new Date();
    const currentYear = currentDate.getFullYear();

    return items.map(item => {
      const newDate = new Date(item.date);
      const itemMonth = this.props.intl.formatDate(newDate, { month: 'long' });
      const itemYear = newDate.getFullYear();
      const displayDate = itemYear !== currentYear ? `${itemMonth} ${itemYear}` : itemMonth;
      let MonthView = null;
      if (displayDate !== lastDisplayDate) {
        lastDisplayDate = displayDate;
        MonthView = (
          <div key={`${itemMonth}${itemYear}`} className={css.month}>
            {displayDate}
          </div>
        );
      }

      let ItemView = null;

      let itemConfig = historyItemsConfig[item.type];
      if (item.type === 'Ticket' && item.issue) {
        itemConfig = historyItemsConfig.IssueTicket;
      }

      if (itemConfig) {
        ItemView = React.createElement(itemConfig.component, {
          key: item.hash,
          toggle: this.props.itemsMap[item.hash],
          onToggle: this.handleClick(item),
          item,
          type: item.type,
          data: item[itemConfig.dataKey],
        });
      }

      if (MonthView) {
        return [MonthView, ItemView];
      }

      return ItemView;
    });
  };

  render() {
    const { hidden, name, loadOnMount } = this.props;

    return (
      <div data-testid="account-history" className={cx(css.content, { [css.content_hidden]: hidden })}>
        <div className={toolbarCss.root}>{!hidden && <Filters onSubmit={this.handleChange} />}</div>
        <div className={css.panelContent}>
          <InfiniteListView
            name={name}
            className={css.list}
            classNameScrollNode={css.list__content}
            onLoad={this.props.onLoad}
            withNavigation={false}
            emptyComponent={<Empty text={i18nNoHistory} />}
            loadOnMount={loadOnMount}
          >
            {this.renderTimeline}
          </InfiniteListView>
        </div>
      </div>
    );
  }
}

export default connect(
  (state, props) => ({
    ...state[c.NAME],
    isLoad: selectors.isLoad(state, props.name),
  }),
  (dispatch, props) => ({
    reload: () => dispatch(actions.reload(props.name)),
    toggleItem: hash => dispatch(a.toggleItem(hash)),
    onLoad: args => dispatch(a.fetch({ ...props.param, ...args })),
    saveFilter: filter => {
      dispatch(a.saveFilter(filter));
      dispatch(actions.reload(props.name));
    },
  }),
)(injectIntl(PanelEntity));
