import React from 'react';
import cx from 'classnames';
import { connect } from 'react-redux';
import { InfiniteListView, actions, selectors } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import Button from '@crm/components/dist/lego2/Button';
import FilesTreeView from 'components/FilesTreeView';
import createI18N from '@yandex-int/i18n';
import * as keyset from './ClientHistory.i18n';
import css from './styles.modules.scss';
import toolbarCss from './toolbar.modules.scss';
import * as c from '../../constants';
import * as a from '../../actions';
import PanelBase from './PanelBase';

const i18n = createI18N(keyset);
const i18nNoFiles = i18n('noFiles');
const i18nReload = i18n('reload');

class PanelFiles extends PanelBase {
  static defaultProps = {
    showTitle: true,
  };

  renderFiles = ({ items }) => {
    if (!items || !items.length) {
      return null;
    }

    return <FilesTreeView files={items} />;
  };

  render() {
    const { hidden, name, loadOnMount, showTitle } = this.props;

    return (
      <div
        data-testid="account-files"
        className={cx(css.content, { [css.content_hidden]: hidden })}
      >
        <div className={toolbarCss.root}>
          {showTitle && (
            <div className={toolbarCss.inputCol}>
              <span className={css.title}>{c.TITLE.FILES}</span>
            </div>
          )}
          <div className={toolbarCss.refreshBtn}>
            <Button size="xs" view="action" onClick={this.props.reload}>
              {i18nReload}
            </Button>
          </div>
        </div>
        <div className={css.panelContent}>
          <InfiniteListView
            name={name}
            className={css.list}
            classNameScrollNode={css.list__content}
            onLoad={this.props.onLoad}
            withNavigation={false}
            emptyComponent={<Empty text={i18nNoFiles} />}
            loadOnMount={loadOnMount}
          >
            {this.renderFiles}
          </InfiniteListView>
        </div>
      </div>
    );
  }
}

export default connect(
  (state, props) => ({
    isLoad: selectors.isLoad(state, props.name),
  }),
  (dispatch, props) => ({
    reload: () => dispatch(actions.reload(props.name)),
    onLoad: (args) => dispatch(a.loadFiles({ ...props.param, ...args })),
  }),
)(PanelFiles);
