import React from 'react';
import PropTypes from 'prop-types';
import ChatList from 'modules/chat/components/ChatList';
import createI18N from '@yandex-int/i18n';
import Name from 'components/Name';
import * as keyset from './HistoryItems.i18n';
import ItemDate from './ItemDate';
import ItemColumnDate from './ItemColumnDate';
import ItemColumn from './ItemColumn';
import ItemWrap from './ItemWrap';
import ItemHeader from './ItemHeader';
import ItemIcon from './ItemIcon';
import ItemBadge from './ItemBadge';

const i18nChat = createI18N(keyset)('chat');

const ChatHistory = (props) => {
  const { toggle, onToggle, data = {}, item } = props;
  const { id, startDate, author } = data;

  return (
    <ItemWrap isOpen={toggle}>
      <ItemHeader onClick={onToggle}>
        <ItemIcon type="Chat" />
        <ItemColumn
          title={
            <span>
              {i18nChat}&nbsp;
              {data.hasFactors && <ItemBadge type="Upsale" />}
            </span>
          }
        />
        <ItemColumn title={author ? <Name name={author.name} /> : null} />
        <ItemColumnDate item={item}>
          <ItemDate date={startDate} />
        </ItemColumnDate>
      </ItemHeader>
      {toggle && <ChatList id={id} />}
    </ItemWrap>
  );
};

ChatHistory.propTypes = {
  data: PropTypes.shape({
    id: PropTypes.number.isRequired,
    state: PropTypes.string,
    title: PropTypes.string,
    data: PropTypes.string,
  }).isRequired,
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
};

ChatHistory.defaultProps = {
  toggle: false,
  item: undefined,
};

export default ChatHistory;
