import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import PlainText from 'components/PlainText';
import StaffCard from 'components/StaffCard';
import FilesList from 'components/FilesList';
import cssCommon from '../TimelineItems/styles/styles';
import css from './styles.modules.scss';
import ItemDate from '../ItemDate';
import ItemColumnDate from '../ItemColumnDate';
import ItemWrap from '../ItemWrap';

const MAX_LENGTH = 180;

const CommentClientHistory = ({
  toggle,
  onToggle,
  item,
  data: { text = '', author, date, files },
}) => {
  const isToggle = text.length > MAX_LENGTH;
  const displayText = isToggle && !toggle ? `${text.substring(0, MAX_LENGTH)}...` : text;

  return (
    <ItemWrap isOpen={toggle} isToggle={isToggle} isHeader onClick={isToggle && onToggle}>
      <div className={cx(cssCommon.header.icon_comment, cssCommon.header.icon_top)}>
        <i className="material-icons">note</i>
      </div>
      <div className={css.main}>
        <div className={css.header}>
          <StaffCard user={author} />
          <ItemColumnDate item={item}>
            <ItemDate date={date} />
          </ItemColumnDate>
        </div>
        {files && <FilesList files={files} isInline />}
        <PlainText className={css.text} text={displayText} link />
      </div>
    </ItemWrap>
  );
};

CommentClientHistory.propTypes = {
  data: PropTypes.instanceOf(Object),
  item: PropTypes.instanceOf(Object),
  onToggle: PropTypes.func.isRequired,
  toggle: PropTypes.bool,
};

CommentClientHistory.defaultProps = {
  toggle: false,
  item: undefined,
  data: {},
};

export default CommentClientHistory;
