import React from 'react';
import createI18N from '@yandex-int/i18n';
import * as keyset from './HistoryItems.i18n';
import css from './TimelineItems/styles/styles';

const i18n = createI18N(keyset);

interface Props {
  type?: 'Upsale';
}

const contentMap = {
  Upsale: i18n('upsale'),
};

const ItemBadge: React.FC<Props> = props => {
  const { type = 'Upsale' } = props;
  return <span className={css.header.item__badge}>{contentMap[type]}</span>;
};

export default ItemBadge;
