import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './TimelineItems/styles/styles';

const ItemColumn = props => {
  const { title, subTitle, right } = props;

  const className = cx(css.header.column, { [css.header.column_right]: right });

  if (title && subTitle) {
    return (
      <div className={className}>
        <div className={css.header.item_title}>{title}</div>
        <div className={css.header.item_sub}>
          {right ? (
            <React.Fragment>
              &nbsp;<span className={css.header.item__floatSubtitle}>{subTitle}</span>
            </React.Fragment>
          ) : (
            subTitle
          )}
        </div>
      </div>
    );
  }

  if (title) {
    return (
      <div className={className}>
        <span className={css.header.item_default}>{title}</span>
      </div>
    );
  }

  if (subTitle) {
    return (
      <div className={className}>
        <span className={css.header.item_default}>{subTitle}</span>
      </div>
    );
  }

  return null;
};

ItemColumn.propTypes = {
  title: PropTypes.node,
  subTitle: PropTypes.node,
  right: PropTypes.bool,
};

ItemColumn.defaultProps = {
  title: undefined,
  subTitle: undefined,
  right: false,
};

export default ItemColumn;
