import React from 'react';
import PropTypes from 'prop-types';
import PreviewAccount from 'components/PreviewValue/PreviewAccount';
import ItemColumn from './ItemColumn';

const sp = e => {
  e.stopPropagation();
};

const ItemColumnDate = props => {
  const { children, item } = props;

  return (
    <ItemColumn
      title={children}
      right
      subTitle={
        item &&
        item.account && (
          <PreviewAccount value={item.account} level="info" login icon theme="ghost" onClick={sp} />
        )
      }
    />
  );
};

ItemColumnDate.propTypes = {
  children: PropTypes.node,
  item: PropTypes.instanceOf(Object),
};

ItemColumnDate.defaultProps = {
  children: undefined,
  item: undefined,
};

export default ItemColumnDate;
