import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';

const ItemDate = props => {
  const { date } = props;

  return (
    <FormattedDate
      value={new Date(date)}
      year="numeric"
      month="numeric"
      day="numeric"
      hour="numeric"
      minute="numeric"
    />
  );
};

ItemDate.propTypes = {
  date: PropTypes.string.isRequired,
};

export default ItemDate;
