import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Icon from 'components/Icons/Icon';
import { ISSUE_TYPES } from 'constants/backendTypes';
import css from './TimelineItems/styles/styles';
import cssMail from './MailClientHistory/styles.modules.scss';

const CONFIG = {
  Call: {
    pack: 'material',
    icon: 'phone',
  },
  Ticket: {
    pack: 'fa',
    icon: 'ticket',
  },
  Request: {
    pack: 'material',
    icon: 'bookmark',
  },
  Chat: {
    pack: 'material',
    icon: 'question_answer',
  },
  [ISSUE_TYPES.APPROVAL]: {
    pack: 'material',
    icon: 'done_all',
  },
  [ISSUE_TYPES.OPPORTUNITY]: {
    pack: 'fa',
    icon: 'briefcase',
  },
};

const ItemIcon = (props) => {
  const { type, children, subIcon, supIcon, size, ...passPropsThrough } = props;

  const config = CONFIG[type];

  let renderSubIcons;
  if (typeof subIcon === 'function') {
    renderSubIcons = subIcon({ className: cssMail.icon_attach });
  } else if (React.isValidElement(subIcon)) {
    renderSubIcons = subIcon;
  }

  let renderSupIcons;
  if (typeof supIcon === 'function') {
    renderSupIcons = supIcon({ className: cssMail.icon_type });
  } else if (React.isValidElement(supIcon)) {
    renderSupIcons = supIcon;
  }

  return (
    <div
      className={cx(
        css.header[`icon_${(type || '').toLowerCase()}`],
        css.header[`icon_size_${size}`],
      )}
      {...passPropsThrough}
    >
      {children || <Icon {...config} />}
      {renderSubIcons}
      {renderSupIcons}
    </div>
  );
};

ItemIcon.propTypes = {
  type: PropTypes.string.isRequired,
  children: PropTypes.node,
  size: PropTypes.string,
  subIcon: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),
  supIcon: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),
};

ItemIcon.defaultProps = {
  children: undefined,
  subIcon: undefined,
  supIcon: undefined,
  size: undefined,
};

export default ItemIcon;
