import { createElement } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './TimelineItems/styles/styles';

/* todo: уйти от наследования в css (composes) для собирания wrapClass и перенести это в js
 * todo: отрефакторить стили для комметария
 * */

const ItemWrap = props => {
  const { isOpen, isHeader, isToggle, ...passPropsThrough } = props;

  let wrapClass;

  if (isHeader) {
    wrapClass = cx(css.item.common, {
      [css.header.common]: !isToggle,
      [css.item.wrap]: isToggle && !isOpen,
      [css.item.wrapOpen]: isToggle && isOpen,
      [css.header.wrap]: isToggle,
    });
  } else {
    wrapClass = isOpen ? css.item.wrapOpen : css.item.wrap;
  }

  return createElement('div', { className: wrapClass, ...passPropsThrough });
};

ItemWrap.propTypes = {
  isOpen: PropTypes.bool,
  isHeader: PropTypes.bool,
  isToggle: PropTypes.bool,
};

ItemWrap.defaultProps = {
  isOpen: false,
  isHeader: false,
  isToggle: false,
};

export default ItemWrap;
