import React from 'react';
import PropTypes from 'prop-types';
import { component as MailPreview } from 'pages/mail/modules/mailPreview';
import cx from 'classnames';
import backendTypes from 'constants/backendTypes';
import LinkModule from 'components/LinkModule';
import cssMail from './styles.modules.scss';
import ItemDate from '../ItemDate';
import ItemColumnDate from '../ItemColumnDate';
import ItemColumn from '../ItemColumn';
import ItemWrap from '../ItemWrap';
import ItemHeader from '../ItemHeader';
import ItemIcon from '../ItemIcon';

const ARROW = {
  Inbox: 'arrow_downward',
  Outbox: 'arrow_upward',
  Draft: 'description',
};

const MailClientHistory = ({
  toggle,
  onToggle,
  item,
  data: { hasAttach, id, date, subject, from, type },
}) => (
  <ItemWrap isOpen={toggle}>
    <ItemHeader onClick={onToggle}>
      <ItemIcon type="Ticket">
        <i className="material-icons">mail</i>
        <i className={cx('material-icons', cssMail.icon_type)}>{ARROW[type]}</i>
        {hasAttach && <i className={cx('material-icons', cssMail.icon_attach)}>attach_file</i>}
      </ItemIcon>
      <ItemColumn title={from} subTitle={subject} />
      <ItemColumnDate item={item}>
        <LinkModule type={backendTypes.PERSONAL_MAIL} id={id} isStopPropagation>
          <ItemDate date={date} />
        </LinkModule>
      </ItemColumnDate>
    </ItemHeader>
    {toggle && <MailPreview mailId={id} className={cssMail.mail} readonly sidebar={false} />}
  </ItemWrap>
);

MailClientHistory.propTypes = {
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
  data: PropTypes.instanceOf(Object),
};

MailClientHistory.defaultProps = {
  item: undefined,
  toggle: false,
  data: {},
};

export default MailClientHistory;
