import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import LinkModule from 'components/LinkModule';
import Massmail from 'modules/massmail/containers/Preview';
import backendTypes from 'constants/backendTypes';
import { Icon } from 'modules/massmail';
import cssMail from '../MailClientHistory/styles.modules.scss';
import ItemDate from '../ItemDate';
import ItemColumnDate from '../ItemColumnDate';
import ItemColumn from '../ItemColumn';
import ItemWrap from '../ItemWrap';
import ItemHeader from '../ItemHeader';
import ItemIcon from '../ItemIcon';

const MassmailHistory = ({
  toggle,
  onToggle,
  item,
  data: { hasAttach, id, recipientId, date, subject, from },
}) => (
  <ItemWrap isOpen={toggle}>
    <ItemHeader onClick={onToggle}>
      <ItemIcon type="Ticket">
        <Icon />
        {hasAttach && <i className={cx('material-icons', cssMail.icon_attach)}>attach_file</i>}
      </ItemIcon>
      <ItemColumn title={from} subTitle={subject} />
      <ItemColumnDate item={item}>
        <LinkModule type={backendTypes.MASSMAIL} id={id} isStopPropagation>
          <ItemDate date={date} />
        </LinkModule>
      </ItemColumnDate>
    </ItemHeader>
    {toggle && <Massmail id={recipientId} className={cssMail.mail} />}
  </ItemWrap>
);

MassmailHistory.propTypes = {
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
  data: PropTypes.instanceOf(Object),
};

MassmailHistory.defaultProps = {
  item: undefined,
  toggle: false,
  data: {},
};

export default MassmailHistory;
