import React from 'react';
import PropTypes from 'prop-types';
import Icon from '@crm/components/dist/lego2/Icon';
import { STLink, Ticket } from 'modules/startrek';
import ItemDate from '../ItemDate';
import ItemColumnDate from '../ItemColumnDate';
import ItemColumn from '../ItemColumn';
import ItemWrap from '../ItemWrap';
import ItemHeader from '../ItemHeader';
import ItemIcon from '../ItemIcon';

const sp = (e) => {
  e.stopPropagation();
};

const STHistory = (props) => {
  const { toggle, onToggle, data = {}, item } = props;
  const { key, state, title, date } = data;

  return (
    <ItemWrap isOpen={toggle}>
      <ItemHeader onClick={onToggle}>
        <ItemIcon type="Request" size="max">
          <Icon size="m" svg="startrek-black" />
        </ItemIcon>
        <ItemColumn title={`${key || ''} ${title || ''}`} subTitle={state} />
        <ItemColumnDate item={item}>
          <STLink stKey={key} target="_blank" rel="noopener noreferrer" onClick={sp}>
            <ItemDate date={date} />
          </STLink>
        </ItemColumnDate>
      </ItemHeader>
      {toggle && <Ticket stKey={key} />}
    </ItemWrap>
  );
};

STHistory.propTypes = {
  data: PropTypes.shape({
    key: PropTypes.string.isRequired,
    state: PropTypes.string,
    title: PropTypes.string.isRequired,
    data: PropTypes.string,
  }).isRequired,
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
};

STHistory.defaultProps = {
  toggle: false,
  item: undefined,
};

export default STHistory;
